﻿<%@ Page Title="Grid View Sort Demo" Language="C#" MasterPageFile="~/MasterPage.master"
    AutoEventWireup="true" CodeFile="GridViewSortDemo.aspx.cs" Inherits="SortDemo.GridViewSortDemo" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>
            <table>
                <tr>
                    <td>
                        <asp:CheckBox ID="cbCaseSensitivity" runat="server" Font-Bold="True" 
                            Text="Case Sensitivity Comparison" />
                    </td>
                    <td>
                        <asp:CheckBox ID="cbCharactorComparer" runat="server" Font-Bold="True" 
                            Text="Use Character Comparer" Checked="True" />
                    </td>
                    <td style="width: 55%">
                        &nbsp;</td>
                </tr>
                <tr>
                    <td colspan="3">
                        <asp:GridView ID="gvPlots" runat="server" AllowPaging="True" AllowSorting="True"
                            AutoGenerateColumns="False" EmptyDataText="There are no data records to display."
                            CellPadding="4" ForeColor="#333333" GridLines="None"  OnSorting="gvPlots_Sorting"
                            OnPageIndexChanging="gvPlots_PageIndexChanging" Height="272px" 
                            style="font-family: Consolas" Width="600px">
                            <RowStyle BackColor="#F7F6F3" ForeColor="#333333" />
                            <Columns>
                                <asp:TemplateField HeaderText="Plot Number" SortExpression="PlotNumber">
                                    <ItemTemplate>
                                        <asp:Label ID="lblPlotNumber" runat="server" Text='<%# Bind("PlotNumber") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Area Code" SortExpression="AreaCode">
                                    <ItemTemplate>
                                        <asp:Label ID="lblAreaCode" runat="server" Text='<%# Bind("AreaCode") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Perimeter" SortExpression="Perimeter">
                                    <ItemTemplate>
                                        <asp:Label ID="lblPerimeter" runat="server" Text='<%# Bind("Perimeter") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Area" SortExpression="Area">
                                    <ItemTemplate>
                                        <asp:Label ID="lblArea" runat="server" Text='<%# Bind("Area") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                            <FooterStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" />
                            <PagerStyle BackColor="#284775" ForeColor="White" HorizontalAlign="Center" />
                            <SelectedRowStyle BackColor="#E2DED6" Font-Bold="True" ForeColor="#333333" />
                            <HeaderStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" Width="200px"
                                Wrap="False" />
                            <AlternatingRowStyle BackColor="White" ForeColor="#284775" />
                        </asp:GridView>
                    </td>
                </tr>
            </table>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
